/**
 * @file
 */
(function ($) {

  Drupal.behaviors.dateAdmin = {};

  Drupal.behaviors.dateAdmin.attach = function (context, settings) {
    // Remove timezone handling options for fields without hours granularity.
    var $hour = $('#edit-field-settings-granularity-hour').once('date-admin');
    if ($hour.length) {
      new Drupal.dateAdmin.TimezoneHandler($hour);
    }
  };

  Drupal.dateAdmin = {};

  /**
 * Constructor for the TimezoneHandler object.
 *
 * This object is responsible for showing the timezone handling options dropdown
 * when the user has chosen to collect hours as part of the date field, and
 * hiding it otherwise.
 */
  Drupal.dateAdmin.TimezoneHandler = function ($checkbox) {
    this.$checkbox = $checkbox;
    this.$dropdown = $('#edit-field-settings-tz-handling');
    this.$timezoneDiv = $('.form-item-field-settings-tz-handling');
    // Store the initial value of the timezone handling dropdown.
    this.storeTimezoneHandling();
    // Toggle the timezone handling section when the user clicks the "Hour"
    // checkbox.
    this.$checkbox.bind('click', $.proxy(this.clickHandler, this));
    // Trigger the click handler so that if the checkbox is unchecked on initial
    // page load, the timezone handling section will be hidden.
    this.clickHandler();
  };

  /**
   * Event handler triggered when the user clicks the "Hour" checkbox.
   */
  Drupal.dateAdmin.TimezoneHandler.prototype.clickHandler = function () {
    if (this.$checkbox.is(':checked')) {
      this.restoreTimezoneHandlingOptions();
    }
    else {
      this.hideTimezoneHandlingOptions();
    }
  };

  /**
   * Hide the timezone handling options section of the form.
   */
  Drupal.dateAdmin.TimezoneHandler.prototype.hideTimezoneHandlingOptions = function () {
    this.storeTimezoneHandling();
    this.$dropdown.val('none');
    this.$timezoneDiv.hide();
  };

  /**
   * Show the timezone handling options section of the form.
   */
  Drupal.dateAdmin.TimezoneHandler.prototype.restoreTimezoneHandlingOptions = function () {
    var val = this.getTimezoneHandling();
    this.$dropdown.val(val);
    this.$timezoneDiv.show();
  };

  /**
   * Store the current value of the timezone handling dropdown.
   */
  Drupal.dateAdmin.TimezoneHandler.prototype.storeTimezoneHandling = function () {
    this._timezoneHandling = this.$dropdown.val();
  };

  /**
   * Return the stored value of the timezone handling dropdown.
   */
  Drupal.dateAdmin.TimezoneHandler.prototype.getTimezoneHandling = function () {
    return this._timezoneHandling;
  };

})(jQuery);
